﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text.RegularExpressions;
using System.Web;

namespace NVCC.WebUI.Utilities
{
    public static class StringHelper
    {
         public static string GetParsedText(string textToSearch, string startText, string stopText)
        {
            if (string.IsNullOrEmpty(textToSearch) || string.IsNullOrEmpty(startText) || string.IsNullOrEmpty(stopText))
                return "";
            var startTextIndex = textToSearch.IndexOf(startText, StringComparison.Ordinal);
            if (startTextIndex == -1)
                return "";
            var startIndex = startTextIndex + startText.Length;
             //Search for stopText after location of startText
            var stopIndex = textToSearch.IndexOf(stopText, startIndex, StringComparison.Ordinal);
            if (stopIndex == -1)
                return "";
            var textNeededLength = stopIndex - startIndex;
            if (textNeededLength <= 0)
                return "";
            var textNeeded = textToSearch.Substring(startIndex, textNeededLength);
            return textNeeded;
        }

        public static string RemoveNonAlphaNumeric(string nonAlphaText)
        {
            if(string.IsNullOrEmpty((nonAlphaText)))
                return nonAlphaText;
            Regex rgx = new Regex("[^a-zA-Z0-9 -]");
            return rgx.Replace(nonAlphaText, "");
        }    
    }
}